@echo off
REM ---------------------------------------------------------------------------
REM
REM  Copyright (C) Intel Corporation, 2003 - 2006.
REM
REM  File:      remote_client_sign.bat
REM
REM  Contents:  batch file which signs a remote client certificate using the AMT device "trusted root CA".
REM
REM ----------------------------------------------------------------------------

REM ############################################################################
REM ###                                                                      ###
REM ### This batch may be called by the Configuration Server program         ###
REM ### in order to generate a demo certificate for the Configuration Server.###
REM ### Normally, you won't need this batch, since you should be using       ###
REM ### Your corporate CA to sign the request.                               ###
REM ### you may customize this script and modify the defaults                ###
REM ### at your own risk.                                                    ###
REM ###                                                                      ###
REM ############################################################################

setlocal

set PATH= %PATH%;../openSSL
set TO_BE_SIGNED=.\remote_client
set SSLEAY_CONFIG=-config .\sign_remote_client_with_trusted_root.cfg

:goto end

REM ### Sign subCA Certificate ###
@echo ### Sign subCA Certificate ###
rem openssl ca %SSLEAY_CONFIG% -policy policy_anything -out %TO_BE_SIGNED%\remote_client.pem -extensions v3_ca -infiles %TO_BE_SIGNED%\certreq.pem < yy.txt
openssl ca %SSLEAY_CONFIG% -policy policy_anything -out %TO_BE_SIGNED%\remote_client.pem -infiles %TO_BE_SIGNED%\certreq.pem < yy.txt

REM ### Convert cert to DER format ###
@echo ### Convert cert to DER format ###
openssl x509 -in %TO_BE_SIGNED%\remote_client.pem -inform PEM -out %TO_BE_SIGNED%\remote_client.der -outform DER

endlocal 

IF NOT %CALLER_WAITS_ON_EXIT%=="" EXIT
:end